/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.oxygen.DimensionOxygenManager;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.registry.DamageSourceRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private final LivingEntity stellaris$livingEntity = (LivingEntity)this;
    @Unique
    private long stellaris$tickSinceLastOxygenCheck;
    @Unique
    private DimensionOxygenManager stellaris$oxygenManager;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void tick(CallbackInfo ci) {
        if (this.firstTick) {
            Utils.handleGravityChange(this.stellaris$livingEntity, this.level());
        }
        if (!this.stellaris$livingEntity.level().isClientSide()) {
            if (this.stellaris$tickSinceLastOxygenCheck > 20L) {
                if (this.stellaris$oxygenManager == null) {
                    this.stellaris$oxygenManager = GlobalOxygenManager.getInstance().getOrCreateDimensionManager((ServerLevel)this.level());
                }
                if (!this.stellaris$oxygenManager.getLevel().dimension().equals(this.stellaris$livingEntity.level().dimension())) {
                    this.stellaris$oxygenManager = GlobalOxygenManager.getInstance().getOrCreateDimensionManager((ServerLevel)this.level());
                }
                if (!this.stellaris$oxygenManager.breath(this.stellaris$livingEntity)) {
                    this.hurt(DamageSourceRegistry.of(this.level(), DamageSourceRegistry.OXYGEN), Stellaris.CONFIG.oxygenDamage);
                }
                this.stellaris$tickSinceLastOxygenCheck = 0L;
            }
            ++this.stellaris$tickSinceLastOxygenCheck;
        }
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        this.stellaris$oxygenManager = GlobalOxygenManager.getInstance().getOrCreateDimensionManager((ServerLevel)this.level());
        Utils.handleGravityChange(this.stellaris$livingEntity, this.level());
        return super.changeDimension(transition);
    }
}

